package com.genuitec.trader.jee5.ejb;

import javax.annotation.Resource;
import javax.ejb.Stateless;

@Stateless(name="Trader")
public class TraderSession implements TraderLocal, TraderRemote {

	@Resource int tradeLimit = 50;
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -5033224581682372760L;

	public TraderSession() {
		super();
		
	}	
	
	public TradeResult buy(String stockSymbol, int shares) {
		if (shares > tradeLimit) {
			System.out.println("Attempt to buy "+shares+" is greater than limit of "+tradeLimit + ".");
			shares = tradeLimit;
		}
		System.out.println("Buying "+shares+" shares of "+stockSymbol + ".");
		return new TradeResult(shares, stockSymbol);
	}

	public TradeResult sell(String stockSymbol, int shares) {
		if (shares > tradeLimit) {
			System.out.println("Attempt to sell "+shares+" is greater than limit of "+tradeLimit);
			shares = tradeLimit;
		}
		System.out.println("Selling "+shares+" shares of "+stockSymbol + ".");
		return new TradeResult(shares, stockSymbol);
	}

}
