package com.genuitec.trader.jee5.ejb;

import java.io.Serializable;

public interface ITrader extends Serializable {

	/**
	 * Buys shares of a stock for a named customer.
	 *
	 * @param customerName      String Customer name
	 * @param stockSymbol       String Stock symbol
	 * @param shares            int Number of shares to buy
	 * @return                  TradeResult Trade Result
	 *                          if there is an error while buying the shares
	 * 
	 */
	public TradeResult buy(String stockSymbol, int shares);

	/**
	 * Sells shares of a stock for a named customer.
	 *
	 * @param customerName      String Customer name
	 * @param stockSymbol       String Stock symbol
	 * @param shares            int Number of shares to buy
	 * @return                  TradeResult Trade Result
	 *                          if there is an error while selling the shares
	 * 
	 */
	public TradeResult sell(String stockSymbol, int shares);

}
