package com.genuitec.trader.jee5.servlet;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


public class ViewDispatcher {

    public static final String ERROR_URL = "/jsp/error.jsp";

    public static void displayErrors(
        HttpServletRequest theRequest,
        HttpServletResponse theResponse,
        ArrayList theErrors) {

        theRequest.setAttribute("errors", theErrors);

        includeRequest(theRequest, theResponse, ERROR_URL);

    }

    public static void displayError(
        HttpServletRequest theRequest,
        HttpServletResponse theResponse,
        String theError) {
        ArrayList errors = new ArrayList();
        errors.add(theError);
        displayErrors(theRequest, theResponse, errors);
    }

    public static void includeRequest(
        HttpServletRequest theRequest,
        HttpServletResponse theResponse,
        String theURL) {

        try {
            theRequest.getRequestDispatcher(theURL).include(theRequest, theResponse);
        } catch (Exception ex) {
            //ex.printStackTrace(theResponse.getWriter());
        }
    }

    /**
     * Constructor for ErrorHandler.
     */
    private ViewDispatcher() {
        super();
    }

}