package com.genuitec.trader.jee5.servlet;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.EJB;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.genuitec.trader.jee5.ejb.ITrader;
import com.genuitec.trader.jee5.ejb.TradeResult;
import com.genuitec.trader.jee5.ejb.TraderLocal;

public class TraderController {

	private ITrader trader;
	
	public static final String RESULT_URL = "/jsp/result.jsp";

	public TraderController(ITrader trader) {
		this.trader = trader;
	}

	public void doTrade(HttpServletRequest theRequest, HttpServletResponse theResponse) {
		TradeResult result = null;
		// no big deal
		System.out.println("#doTrade");
		OrderForm orderForm = new OrderForm();

		orderForm.populate(theRequest);

		// terminate operation if errors
		if (orderForm.hasErrors()) {
			ViewDispatcher.displayErrors(theRequest, theResponse, orderForm
					.getErrors());
		}

		// perform transaction using Trader EJB
		try {
			if (orderForm.isSell()) {
				result = getTrader().sell(orderForm.getSymbol(),
						orderForm.getQuantity());
			} else {
				result = getTrader().buy(orderForm.getSymbol(),
						orderForm.getQuantity());
			}

			theRequest.setAttribute("TradeResult", result);
			System.out.println("result: " + result.getStockSymbol() + "  "
					+ result.getNumberTraded());

			ViewDispatcher.includeRequest(theRequest, theResponse, RESULT_URL);

		} catch (Exception ex) {
			ViewDispatcher.displayError(theRequest, theResponse,
					"Exception creating Trader");
		}
	}

	public TradeResult doSell(String theSymbol, int theShareCount)
			throws RemoteException, NamingException, CreateException {

		return getTrader().sell(theSymbol, theShareCount);
	}

	public TradeResult doBuy(String theSymbol, int theShareCount)
			throws RemoteException, NamingException, CreateException {

		return getTrader().buy(theSymbol, theShareCount);
	}
	
	public ITrader getTrader() {
		return trader;
	}

}
