package com.genuitec.trader.jee5.servlet;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;

/**
 * @version 	1.0
 * @author
 */
public class OrderForm {

    private String symbol;
    private int quantity;
    private String transactionType;
    private ArrayList errors;

    /**
     * Constructor for Order.
     */
    public OrderForm() {
        //super();
    }

    public void populate(HttpServletRequest theRequest) {
        String param = null;
        int quantity = 0;

        //process transaction type
        //Object foo = theParams.get("type");
        //System.out.println("foo: " + foo);

        param = theRequest.getParameter("type");
        if (param == null) {
            getErrors().add("Transaction type undefined.");
        } else if (param.equals("buy") || param.equals("sell")) {
            setTransactionType(param);
        } else {
            getErrors().add("Invalid transaction type; expected \"buy\" or \"sell\".");
        }

        //process stock symbol
        param = theRequest.getParameter("symbol");
        if (param != null) {
            setSymbol(param);
        } else {
            getErrors().add("Stock symbol undefined.");
        }

        //process quantity of shares involved
        param = theRequest.getParameter("quantity");
        if (param == null) {
            getErrors().add("Number of shares undefined.");
        }

        try {
            setQuantity(Integer.parseInt(param));
        } catch (Exception ex) {
            getErrors().add("Number of shares must be a postitive integer.");
        }
    }

    /**
     * Gets the quantity.
     * @return Returns a int
     */
    public int getQuantity() {
        return quantity;
    }

    /**
     * Sets the quantity.
     * @param quantity The quantity to set
     */
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    /**
     * Gets the symbol.
     * @return Returns a String
     */
    public String getSymbol() {
        return symbol;
    }

    /**
     * Sets the symbol.
     * @param symbol The symbol to set
     */
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    /**
     * Gets the transactionType.
     * @return Returns a String
     */
    public String getTransactionType() {
        return transactionType;
    }

    /**
     * Sets the transactionType.
     * @param transactionType The transactionType to set
     */
    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public boolean isBuy() {
        return "buy".equals(getTransactionType());
    }

    public boolean isSell() {
        return "sell".equals(getTransactionType());
    }

    public ArrayList getErrors() {
        if (!hasErrors()) {
            errors = new ArrayList();
        }
        return errors;
    }

    public boolean hasErrors() {
        return basicGetErrors() != null;
    }

    private ArrayList basicGetErrors() {
        return errors;
    }
}