package com.myeclipseide.mycart;

import java.io.Serializable;

public class ShoppingCartItem implements Comparable<ShoppingCartItem>, Serializable {
	private static final long serialVersionUID = 4134652647253355430L;
	
	private Product product;
	private int quantity;
	
	public ShoppingCartItem(Product product, int quantity) {
		this.product = product;
		this.quantity = quantity;
	}

	public Product getProduct() {
		return product;
	}

	public int getQuantity() {
		return quantity;
	}
	
	public void incrementQuantity() {
		quantity++;
	}

	public int getUnitPriceInCents() {
		return product.getPriceInCents();
	}
	
	public String getUnitPriceInDollars() {
		return product.getPriceInDollars();
	}
	
	public int getTotalPriceInCents() {
		return (quantity * getUnitPriceInCents());
	}
	
	public String getTotalPriceInDollars() {
		return Util.getPriceInDollars(getTotalPriceInCents());
	}
	
	@Override
	public boolean equals(Object o) {
		return o instanceof ShoppingCartItem &&
			product.equals(((ShoppingCartItem) o).product);
	}
	
	@Override
	public int hashCode() {
		return product.hashCode();
	}
	
	public int compareTo(ShoppingCartItem o) {
		return product.compareTo(o.product);
	}
}
