package com.myeclipseide.mycart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

@Service("cartService")
public class CartServiceImpl implements CartService {
	
	private ShoppingCart cart;
	
	private Map<Long, Product> products = new HashMap<Long, Product>();
	private List<Product> recommendations = new ArrayList<Product>();
	private List<String> shippingOptions;
	
	public CartServiceImpl() {
		addProduct(1L, "Lemons", 100, "lemon.jpg");
		addProduct(2L, "Apples", 3995, "apples.jpg");
		addProduct(3L, "Music Player", 159995, "musicplayer.jpg");
		addProduct(4L, "T-Shirts", 57950, "tshirt.jpg");
	}
	
	private void addProduct(Long id, String desc, int priceInCents, String imgUrl) {
		Product product = new Product(id, desc, priceInCents, imgUrl);
		products.put(id, product);
		if (id == 3 || id == 4) {
			recommendations.add(product);
		}
	}
	
	//@Override
	public ShoppingCart getShoppingCart() {
		return cart;
	}
	
	public void setShoppingCart(ShoppingCart cart) {
		this.cart = cart;
	}
	
	//@Override
	public List<Product> getProducts() {
		List<Product> list = new ArrayList<Product>(products.values());
		Collections.sort(list);
		return list;
	}
	
	//@Override
	public Product getProduct(long productId) {
		return products.get(productId);
	}
	
	//@Override
	public List<Product> getRecommendations() {
		return recommendations;
	}
	
	//@Override
	public List<String> getShippingOptions() {
		return shippingOptions;
	}
	
	public void setShippingOptions(List<String> options) {
		this.shippingOptions = options;
	}
	
	//@Override
	public void submitOrderForPayment() {
		cart.clear();
	}
}
