<%@ page isELIgnored="false" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>

<c:set var="contextPath" value="${pageContext.request.contextPath}"/>
<c:set var="imagesPath" value="${contextPath}/images"/>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"> 
<html>
	<head>
		<title>Products</title>
	</head>
	<body>
		<div id="bd" class="yui-t6">
			<h1> Shopping Cart</h1>
			<div id="yui-main">
				<div class="yui-b">
					<h2>Your Cart</h2>
					Your cart currently contains ${shoppingCart.itemCount} items.
					<a href="${contextPath}/checkout.do">Checkout &raquo;</a>
				
					<h2>Our Products</h2>
					<table>
						<c:forEach var="product" items="${products}">
							<tr>
								<td><img class="product-thumb" src="${imagesPath}/${product.imageUrl}" alt="${product.description}" /></td>
								<td>${product.description}</td>
								<td class="numeric">${product.priceInDollars}</td>
								<td><a href="${contextPath}/addToCart.do?productId=${product.id}">[add to cart]</a></td>
							</tr>
						</c:forEach>
					</table>
				</div>
			</div>
			<div class="yui-b">
				<h2>30 Day Replacement Guarantee</h2>
				<p>The 30 Day Replacement Guarantee seeks to assist Buyers who have been defrauded by qualified sellers on the Website. If at the time of delivery and/or within 30 days from the date of delivery of the product/s, if any defect is found, then the buyer of the product/s can ask for replacement of the product/s from the seller</p>
				
				<h2>Disclaimer</h2>
				<p>Pricing on any product(s) as is reflected on the Website may due to some technical issue, typographical error or product information published by seller may be incorrectly reflected and in such an event seller may cancel such your order(s).</p>
			</div>
		</div>
	</body>
</html>
