package com.myeclipseide.examples.dwrspring.jpa;

import java.util.Date;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * Payment generated by MyEclipse Persistence Tools
 */
@Entity
@Table(name = "PAYMENT", schema = "CLASSICCARS", uniqueConstraints = {})
public class Payment implements java.io.Serializable {
	private static final long serialVersionUID = 1L;

	// Fields

	private PaymentId id;

	private Customer customer;

	private Date paymentdate;

	private Double amount;

	// Constructors

	public Payment() {
		/* default constructor */
	}

	/* minimal constructor */
	public Payment(PaymentId id, Customer customer) {
		this.id = id;
		this.customer = customer;
	}

	/* full constructor */
	public Payment(PaymentId id, Customer customer, Date paymentdate,
			Double amount) {
		this.id = id;
		this.customer = customer;
		this.paymentdate = paymentdate;
		this.amount = amount;
	}

	// Property accessors
	@EmbeddedId
	@AttributeOverrides( {
			@AttributeOverride(name = "customernumber", column = @Column(name = "CUSTOMERNUMBER", unique = false, nullable = false, insertable = true, updatable = true)),
			@AttributeOverride(name = "checknumber", column = @Column(name = "CHECKNUMBER", unique = false, nullable = false, insertable = true, updatable = true, length = 50)) })
	public PaymentId getId() {
		return this.id;
	}

	public void setId(PaymentId id) {
		this.id = id;
	}

	@ManyToOne(cascade = {}, fetch = FetchType.LAZY)
	@JoinColumn(name = "CUSTOMERNUMBER", unique = false, nullable = false, insertable = false, updatable = false)
	public Customer getCustomer() {
		return this.customer;
	}

	public void setCustomer(Customer customer) {
		this.customer = customer;
	}

	@Temporal(TemporalType.DATE)
	@Column(name = "PAYMENTDATE", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public Date getPaymentdate() {
		return this.paymentdate;
	}

	public void setPaymentdate(Date paymentdate) {
		this.paymentdate = paymentdate;
	}

	@Column(name = "AMOUNT", unique = false, nullable = true, insertable = true, updatable = true, precision = 52, scale = 0)
	public Double getAmount() {
		return this.amount;
	}

	public void setAmount(Double amount) {
		this.amount = amount;
	}

}
