package com.myeclipseide.examples.dwrspring.jpa;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * Employee generated by MyEclipse Persistence Tools
 */
@Entity
@Table(name = "EMPLOYEE", schema = "CLASSICCARS", uniqueConstraints = {})
public class Employee implements java.io.Serializable {
	private static final long serialVersionUID = 1L;

	// Fields

	private Integer employeenumber;

	private Office office;

	private String lastname;

	private String firstname;

	private String extension;

	private String email;

	private Integer reportsto;

	private String jobtitle;

	// Constructors

	public Employee() {
		/* default constructor */
	}

	/* minimal constructor */
	public Employee(Integer employeenumber) {
		this.employeenumber = employeenumber;
	}

	/* full constructor */
	public Employee(Integer employeenumber, Office office, String lastname,
			String firstname, String extension, String email,
			Integer reportsto, String jobtitle) {
		this.employeenumber = employeenumber;
		this.office = office;
		this.lastname = lastname;
		this.firstname = firstname;
		this.extension = extension;
		this.email = email;
		this.reportsto = reportsto;
		this.jobtitle = jobtitle;
	}

	// Property accessors
	@Id
	@Column(name = "EMPLOYEENUMBER", unique = true, nullable = false, insertable = true, updatable = true)
	public Integer getEmployeenumber() {
		return this.employeenumber;
	}

	public void setEmployeenumber(Integer employeenumber) {
		this.employeenumber = employeenumber;
	}

	@ManyToOne(cascade = {}, fetch = FetchType.LAZY)
	@JoinColumn(name = "OFFICECODE", unique = false, nullable = true, insertable = true, updatable = true)
	public Office getOffice() {
		return this.office;
	}

	public void setOffice(Office office) {
		this.office = office;
	}

	@Column(name = "LASTNAME", unique = false, nullable = true, insertable = true, updatable = true, length = 50)
	public String getLastname() {
		return this.lastname;
	}

	public void setLastname(String lastname) {
		this.lastname = lastname;
	}

	@Column(name = "FIRSTNAME", unique = false, nullable = true, insertable = true, updatable = true, length = 50)
	public String getFirstname() {
		return this.firstname;
	}

	public void setFirstname(String firstname) {
		this.firstname = firstname;
	}

	@Column(name = "EXTENSION", unique = false, nullable = true, insertable = true, updatable = true, length = 10)
	public String getExtension() {
		return this.extension;
	}

	public void setExtension(String extension) {
		this.extension = extension;
	}

	@Column(name = "EMAIL", unique = false, nullable = true, insertable = true, updatable = true, length = 100)
	public String getEmail() {
		return this.email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	@Column(name = "REPORTSTO", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getReportsto() {
		return this.reportsto;
	}

	public void setReportsto(Integer reportsto) {
		this.reportsto = reportsto;
	}

	@Column(name = "JOBTITLE", unique = false, nullable = true, insertable = true, updatable = true, length = 50)
	public String getJobtitle() {
		return this.jobtitle;
	}

	public void setJobtitle(String jobtitle) {
		this.jobtitle = jobtitle;
	}

}
