/*
 * ManageContactFrame.java
 *
 * Created on __DATE__, __TIME__
 */

package com.myeclipseide.examples.m4m;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;


/**
 * 
 * @author __USER__
 */
public class ManageContactFrame extends javax.swing.JFrame {
	private static final long serialVersionUID = 1L;
	
	private DefaultListModel listModel;
	private EditContactDialog editContactDialog;

	/** Creates new form ManageContactFrame */
	public ManageContactFrame() {
		initComponents();
		initContacts();

		editContactDialog = new EditContactDialog(this, true);
	}

	private void initContacts() {
		BufferedReader reader = null;
		listModel = new DefaultListModel();

		try {
			reader = new BufferedReader(new InputStreamReader(
					new FileInputStream("resources/Contacts.properties")));

			while (reader.ready()) {
				String value = reader.readLine();
				listModel.addElement(new Contact(value));
			}

			reader.close();
		} catch (Exception e) {
			e.printStackTrace();
		}

		contactList.setModel(listModel);

		if (listModel.size() > 0)
			contactList.setSelectedIndex(0);

		updateContactCount();
	}

	public void updateContactCount() {
		contactCount.setText("(" + listModel.size() + " contacts)");
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	// GEN-BEGIN:initComponents
	// <editor-fold defaultstate="collapsed" desc=" Generated Code ">
	private void initComponents() {
		titleLabel = new javax.swing.JLabel();
		contactCount = new javax.swing.JLabel();
		jSeparator1 = new javax.swing.JSeparator();
		contactScrollPane = new javax.swing.JScrollPane();
		contactList = new javax.swing.JList();
		addButton = new javax.swing.JButton();
		editButton = new javax.swing.JButton();
		removeButton = new javax.swing.JButton();
		saveButton = new javax.swing.JButton();
		closeButton = new javax.swing.JButton();

		setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
		setTitle("Contact Manager");
		addWindowListener(new java.awt.event.WindowAdapter() {
			@Override
			public void windowClosing(java.awt.event.WindowEvent evt) {
				formWindowClosing(evt);
			}
		});

		titleLabel.setText("Manage Contacts");

		contactCount.setText("(xx contacts)");

		contactList
				.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
		contactScrollPane.setViewportView(contactList);

		addButton.setText("Add...");
		addButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				addButtonActionPerformed(evt);
			}
		});

		editButton.setText("Edit...");
		editButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				editButtonActionPerformed(evt);
			}
		});

		removeButton.setText("Remove");
		removeButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				removeButtonActionPerformed(evt);
			}
		});

		saveButton.setText("Save");
		saveButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				saveButtonActionPerformed(evt);
			}
		});

		closeButton.setText("Close");
		closeButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				closeButtonActionPerformed(evt);
			}
		});

		org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(
				getContentPane());
		getContentPane().setLayout(layout);
		layout
				.setHorizontalGroup(layout
						.createParallelGroup(
								org.jdesktop.layout.GroupLayout.LEADING)
						.add(
								layout
										.createSequentialGroup()
										.addContainerGap()
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.LEADING)
														.add(
																org.jdesktop.layout.GroupLayout.TRAILING,
																layout
																		.createSequentialGroup()
																		.add(
																				contactScrollPane,
																				org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																				205,
																				org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
																		.addPreferredGap(
																				org.jdesktop.layout.LayoutStyle.RELATED,
																				8,
																				Short.MAX_VALUE)
																		.add(
																				layout
																						.createParallelGroup(
																								org.jdesktop.layout.GroupLayout.TRAILING)
																						.add(
																								addButton)
																						.add(
																								editButton)
																						.add(
																								removeButton)
																						.add(
																								closeButton)
																						.add(
																								saveButton)))
														.add(
																jSeparator1,
																org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																284,
																Short.MAX_VALUE)
														.add(
																layout
																		.createSequentialGroup()
																		.add(
																				titleLabel)
																		.addPreferredGap(
																				org.jdesktop.layout.LayoutStyle.RELATED)
																		.add(
																				contactCount)))
										.addContainerGap()));

		layout.linkSize(new java.awt.Component[] { addButton, closeButton,
				editButton, removeButton, saveButton },
				org.jdesktop.layout.GroupLayout.HORIZONTAL);

		layout
				.setVerticalGroup(layout
						.createParallelGroup(
								org.jdesktop.layout.GroupLayout.LEADING)
						.add(
								layout
										.createSequentialGroup()
										.addContainerGap()
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.BASELINE)
														.add(titleLabel).add(
																contactCount))
										.addPreferredGap(
												org.jdesktop.layout.LayoutStyle.RELATED)
										.add(
												jSeparator1,
												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
												10,
												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
										.addPreferredGap(
												org.jdesktop.layout.LayoutStyle.RELATED)
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.LEADING)
														.add(
																layout
																		.createSequentialGroup()
																		.add(
																				addButton)
																		.addPreferredGap(
																				org.jdesktop.layout.LayoutStyle.RELATED)
																		.add(
																				editButton)
																		.addPreferredGap(
																				org.jdesktop.layout.LayoutStyle.RELATED)
																		.add(
																				removeButton)
																		.addPreferredGap(
																				org.jdesktop.layout.LayoutStyle.RELATED,
																				109,
																				Short.MAX_VALUE)
																		.add(
																				saveButton)
																		.addPreferredGap(
																				org.jdesktop.layout.LayoutStyle.RELATED)
																		.add(
																				closeButton))
														.add(
																org.jdesktop.layout.GroupLayout.TRAILING,
																contactScrollPane,
																org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																242,
																Short.MAX_VALUE))
										.addContainerGap()));
		java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit()
				.getScreenSize();
		setBounds((screenSize.width - 325) / 2, (screenSize.height - 300) / 2,
				325, 300);
	}// </editor-fold>//GEN-END:initComponents

	// GEN-FIRST:event_saveButtonActionPerformed
	private void saveButtonActionPerformed(java.awt.event.ActionEvent evt) {
		BufferedWriter writer = null;
		String lineSeparator = System.getProperty("line.separator");

		try {
			writer = new BufferedWriter(new OutputStreamWriter(
					new FileOutputStream("Contacts.properties")));

			for (int i = 0; i < listModel.size(); i++) {
				writer.write(((Contact) listModel.get(i)).getFormattedValue());
				writer.write(lineSeparator);
			}

			writer.flush();
			writer.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}// GEN-LAST:event_saveButtonActionPerformed

	// GEN-FIRST:event_removeButtonActionPerformed
	private void removeButtonActionPerformed(java.awt.event.ActionEvent evt) {
		Contact contact = (Contact) contactList.getSelectedValue();

		if (contact == null)
			return;

		int response = JOptionPane.showConfirmDialog(this,
				"Are you sure you want to erase '" + contact + "'?",
				"Remove Confirmation", JOptionPane.YES_NO_OPTION);

		if (response == JOptionPane.YES_OPTION) {
			listModel.removeElement(contact);
			updateContactCount();
		}
	}// GEN-LAST:event_removeButtonActionPerformed

	// GEN-FIRST:event_addButtonActionPerformed
	private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {
		Contact contact = editContactDialog.addEditContact(null);
		
		if(contact != null) {
			listModel.addElement(contact);
			updateContactCount();
		}
	}// GEN-LAST:event_addButtonActionPerformed

	// GEN-FIRST:event_editButtonActionPerformed
	private void editButtonActionPerformed(java.awt.event.ActionEvent evt) {
		Contact contact = (Contact) contactList.getSelectedValue();

		if (contact == null)
			return;

		editContactDialog.addEditContact(contact);
		contactList.repaint();
	}// GEN-LAST:event_editButtonActionPerformed

	// GEN-FIRST:event_formWindowClosing
	private void formWindowClosing(java.awt.event.WindowEvent evt) {
		closeButtonActionPerformed(null);
	}// GEN-LAST:event_formWindowClosing

	// GEN-FIRST:event_closeButtonActionPerformed
	private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {
		int response = JOptionPane.showConfirmDialog(this,
				"Are you sure you want to exit?", "Confirm Exit",
				JOptionPane.YES_NO_OPTION);

		if (response == JOptionPane.OK_OPTION)
			System.exit(0);
	}// GEN-LAST:event_closeButtonActionPerformed

	// GEN-BEGIN:variables
	// Variables declaration - do not modify
	private javax.swing.JButton addButton;
	private javax.swing.JButton closeButton;
	private javax.swing.JLabel contactCount;
	private javax.swing.JList contactList;
	private javax.swing.JScrollPane contactScrollPane;
	private javax.swing.JButton editButton;
	private javax.swing.JSeparator jSeparator1;
	private javax.swing.JButton removeButton;
	private javax.swing.JButton saveButton;
	private javax.swing.JLabel titleLabel;
	// End of variables declaration//GEN-END:variables

}