/*
 * EditContactDialog.java
 *
 * Created on __DATE__, __TIME__
 */

package com.myeclipseide.examples.m4m;


/**
 *
 * @author  __USER__
 */
public class EditContactDialog extends javax.swing.JDialog {
	private static final long serialVersionUID = 1L;
	
	private Contact currentContact;

	/* Creates new form EditContactDialog */
	public EditContactDialog(java.awt.Frame parent, boolean modal) {
		super(parent, modal);
		initComponents();
	}

	public Contact addEditContact(Contact contact) {
		this.currentContact = contact;
		
		if (this.currentContact == null) {
			/* Add */
			titleLabel.setText("Add Contact");
			addButton.setText("Add");
			
			/* Reset fields */
			firstNameTextField.setText("");
			lastNameTextField.setText("");
			emailTextField.setText("");
			phoneTextField.setText("");
			notesTextArea.setText("");
			
			this.currentContact = new Contact();
		} else {
			/* Edit */
			titleLabel.setText("Edit Contact");
			addButton.setText("Update");

			firstNameTextField.setText(contact.getFirstName());
			lastNameTextField.setText(contact.getLastName());
			emailTextField.setText(contact.getEmail());
			phoneTextField.setText(contact.getPhone());
			notesTextArea.setText(contact.getNotes());
		}

		setLocationRelativeTo(getParent());
		setVisible(true);
		
		return this.currentContact;
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	//GEN-BEGIN:initComponents
	// <editor-fold defaultstate="collapsed" desc=" Generated Code ">
	private void initComponents() {
		titleLabel = new javax.swing.JLabel();
		jSeparator1 = new javax.swing.JSeparator();
		firstNameLabel = new javax.swing.JLabel();
		firstNameTextField = new javax.swing.JTextField();
		lastNameLabel = new javax.swing.JLabel();
		lastNameTextField = new javax.swing.JTextField();
		emailLabel = new javax.swing.JLabel();
		emailTextField = new javax.swing.JTextField();
		phoneLabel = new javax.swing.JLabel();
		phoneTextField = new javax.swing.JTextField();
		addButton = new javax.swing.JButton();
		cancelButton = new javax.swing.JButton();
		notesLabel = new javax.swing.JLabel();
		jScrollPane1 = new javax.swing.JScrollPane();
		notesTextArea = new javax.swing.JTextArea();

		setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		addWindowListener(new java.awt.event.WindowAdapter() {
			@Override
			public void windowClosing(java.awt.event.WindowEvent evt) {
				formWindowClosing(evt);
			}
		});

		titleLabel.setText("Add / Edit Contact");

		firstNameLabel.setText("First Name:");

		lastNameLabel.setText("Last Name:");

		emailLabel.setText("Email:");

		phoneLabel.setText("Phone:");

		addButton.setText("Add / Update");
		addButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				addButtonActionPerformed(evt);
			}
		});

		cancelButton.setText("Cancel");
		cancelButton.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				cancelButtonActionPerformed(evt);
			}
		});

		notesLabel.setText("Notes:");

		notesTextArea.setColumns(20);
		notesTextArea.setRows(5);
		jScrollPane1.setViewportView(notesTextArea);

		org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(
				getContentPane());
		getContentPane().setLayout(layout);
		layout
				.setHorizontalGroup(layout
						.createParallelGroup(
								org.jdesktop.layout.GroupLayout.LEADING)
						.add(
								layout
										.createSequentialGroup()
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.LEADING)
														.add(
																layout
																		.createSequentialGroup()
																		.add(
																				10,
																				10,
																				10)
																		.add(
																				titleLabel))
														.add(
																layout
																		.createParallelGroup(
																				org.jdesktop.layout.GroupLayout.TRAILING,
																				false)
																		.add(
																				org.jdesktop.layout.GroupLayout.LEADING,
																				layout
																						.createSequentialGroup()
																						.addContainerGap()
																						.add(
																								jSeparator1))
																		.add(
																				org.jdesktop.layout.GroupLayout.LEADING,
																				layout
																						.createSequentialGroup()
																						.add(
																								10,
																								10,
																								10)
																						.add(
																								layout
																										.createParallelGroup(
																												org.jdesktop.layout.GroupLayout.LEADING)
																										.add(
																												org.jdesktop.layout.GroupLayout.TRAILING,
																												firstNameLabel)
																										.add(
																												org.jdesktop.layout.GroupLayout.TRAILING,
																												emailLabel)
																										.add(
																												org.jdesktop.layout.GroupLayout.TRAILING,
																												notesLabel))
																						.addPreferredGap(
																								org.jdesktop.layout.LayoutStyle.RELATED)
																						.add(
																								layout
																										.createParallelGroup(
																												org.jdesktop.layout.GroupLayout.TRAILING,
																												false)
																										.add(
																												layout
																														.createSequentialGroup()
																														.add(
																																emailTextField,
																																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																																org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
																														.addPreferredGap(
																																org.jdesktop.layout.LayoutStyle.RELATED,
																																org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																																Short.MAX_VALUE)
																														.add(
																																phoneLabel))
																										.add(
																												org.jdesktop.layout.GroupLayout.LEADING,
																												layout
																														.createSequentialGroup()
																														.add(
																																firstNameTextField,
																																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																																125,
																																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
																														.addPreferredGap(
																																org.jdesktop.layout.LayoutStyle.RELATED)
																														.add(
																																lastNameLabel)))
																						.addPreferredGap(
																								org.jdesktop.layout.LayoutStyle.RELATED)
																						.add(
																								layout
																										.createParallelGroup(
																												org.jdesktop.layout.GroupLayout.LEADING)
																										.add(
																												phoneTextField,
																												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																												org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
																										.add(
																												lastNameTextField,
																												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																												org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))))
										.addContainerGap(
												org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
												Short.MAX_VALUE))
						.add(
								org.jdesktop.layout.GroupLayout.TRAILING,
								layout
										.createSequentialGroup()
										.addContainerGap(33, Short.MAX_VALUE)
										.add(
												jScrollPane1,
												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
												348,
												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
										.addContainerGap())
						.add(
								org.jdesktop.layout.GroupLayout.TRAILING,
								layout
										.createSequentialGroup()
										.addContainerGap(213, Short.MAX_VALUE)
										.add(addButton)
										.addPreferredGap(
												org.jdesktop.layout.LayoutStyle.RELATED)
										.add(cancelButton).addContainerGap()));

		layout.linkSize(new java.awt.Component[] { emailTextField,
				firstNameTextField, lastNameTextField, phoneTextField },
				org.jdesktop.layout.GroupLayout.HORIZONTAL);

		layout
				.setVerticalGroup(layout
						.createParallelGroup(
								org.jdesktop.layout.GroupLayout.LEADING)
						.add(
								layout
										.createSequentialGroup()
										.addContainerGap()
										.add(titleLabel)
										.addPreferredGap(
												org.jdesktop.layout.LayoutStyle.RELATED)
										.add(
												jSeparator1,
												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
												10,
												org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
										.addPreferredGap(
												org.jdesktop.layout.LayoutStyle.RELATED)
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.BASELINE)
														.add(firstNameLabel)
														.add(
																firstNameTextField,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
														.add(lastNameLabel)
														.add(
																lastNameTextField,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
										.addPreferredGap(
												org.jdesktop.layout.LayoutStyle.RELATED)
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.BASELINE)
														.add(emailLabel)
														.add(
																emailTextField,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
														.add(phoneLabel)
														.add(
																phoneTextField,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
																org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
																org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
										.add(24, 24, 24)
										.add(notesLabel)
										.addPreferredGap(
												org.jdesktop.layout.LayoutStyle.RELATED)
										.add(
												jScrollPane1,
												org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
												151, Short.MAX_VALUE)
										.addPreferredGap(
												org.jdesktop.layout.LayoutStyle.RELATED)
										.add(
												layout
														.createParallelGroup(
																org.jdesktop.layout.GroupLayout.BASELINE)
														.add(cancelButton).add(
																addButton))
										.addContainerGap()));
		pack();
	}// </editor-fold>//GEN-END:initComponents

	//GEN-FIRST:event_formWindowClosing
	private void formWindowClosing(java.awt.event.WindowEvent evt) {
		cancelButtonActionPerformed(null);
	}//GEN-LAST:event_formWindowClosing

	//GEN-FIRST:event_cancelButtonActionPerformed
	private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {
		currentContact = null;
		
		setVisible(false);
	}//GEN-LAST:event_cancelButtonActionPerformed

	//GEN-FIRST:event_addButtonActionPerformed
	private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {
		currentContact.setFirstName(firstNameTextField.getText());
		currentContact.setLastName(lastNameTextField.getText());
		currentContact.setEmail(emailTextField.getText());
		currentContact.setPhone(phoneTextField.getText());
		currentContact.setNotes(notesTextArea.getText());
		
		setVisible(false);
	}//GEN-LAST:event_addButtonActionPerformed

	//GEN-BEGIN:variables
	// Variables declaration - do not modify
	private javax.swing.JButton addButton;
	private javax.swing.JButton cancelButton;
	private javax.swing.JLabel emailLabel;
	private javax.swing.JTextField emailTextField;
	private javax.swing.JLabel firstNameLabel;
	private javax.swing.JTextField firstNameTextField;
	private javax.swing.JScrollPane jScrollPane1;
	private javax.swing.JSeparator jSeparator1;
	private javax.swing.JLabel lastNameLabel;
	private javax.swing.JTextField lastNameTextField;
	private javax.swing.JLabel notesLabel;
	private javax.swing.JTextArea notesTextArea;
	private javax.swing.JLabel phoneLabel;
	private javax.swing.JTextField phoneTextField;
	private javax.swing.JLabel titleLabel;
	// End of variables declaration//GEN-END:variables

}