package com.myeclipseide.examples.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public class ManageContactFrame extends JFrame {

	private static final long serialVersionUID = 1L;
	
	private JPanel contentPane;
	private DefaultListModel<Contact> listModel;
	private EditContactDialog editContactDialog;
	private JList<Contact> contactList;
	private JLabel contactCount;

	private void initContacts() {
		BufferedReader reader = null;
		listModel = new DefaultListModel<Contact>();

		try {
			reader = new BufferedReader(new InputStreamReader(
					new FileInputStream("resources/Contacts.properties")));

			while (reader.ready()) {
				String value = reader.readLine();
				listModel.addElement(new Contact(value));
			}
			
			reader.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		contactList.setModel(listModel);

		if (listModel.size() > 0)
			contactList.setSelectedIndex(0);

		updateContactCount();
	}
	
	public void updateContactCount() {
		
		contactCount.setText("(" + listModel.size() + " contacts)");
	}

	/**
	 * Create the frame.
	 */
	public ManageContactFrame() {
		
		setTitle("Manage Contacts");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(100, 100, 427, 300);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		contentPane.setLayout(null);
		
		JButton addButton = new JButton("Add");
		addButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				addButtonActionPerformed(e);
			}
		});
		addButton.setBounds(289, 38, 89, 23);
		contentPane.add(addButton);
		
		JButton editButton = new JButton("Edit");
		editButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				editButtonActionPerformed(e);
			}
		});
		editButton.setBounds(290, 72, 89, 23);
		contentPane.add(editButton);
		
		JButton removeButton = new JButton("Remove");
		removeButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				removeButtonActionPerformed(e);
			}
		});
		removeButton.setBounds(290, 106, 89, 23);
		contentPane.add(removeButton);
		
		JButton saveButton = new JButton("Save");
		saveButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				saveButtonActionPerformed(e);
			}
		});
		saveButton.setBounds(290, 176, 89, 23);
		contentPane.add(saveButton);
		
		JButton btnNewButton_4 = new JButton("Close");
		btnNewButton_4.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				closeButtonActionPerformed(e);
			}
		});
		btnNewButton_4.setBounds(290, 210, 89, 23);
		contentPane.add(btnNewButton_4);
		
				
		contactList = new JList<Contact>();
		contactList.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
		
		contactList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		contactList.setBounds(29, 41, 249, 192);
		contentPane.add(contactList);
		
		contactCount = new JLabel("(xx contacts)");
		contactCount.setBounds(29, 16, 150, 14);
		contentPane.add(contactCount);
		
		initContacts();
		editContactDialog = new EditContactDialog();
		
	}
	
	private void saveButtonActionPerformed(java.awt.event.ActionEvent evt) {
		BufferedWriter writer = null;
		String lineSeparator = System.getProperty("line.separator");

		try {
			writer = new BufferedWriter(new OutputStreamWriter(
					new FileOutputStream("Contacts.properties")));

			for (int i = 0; i < listModel.size(); i++) {
				writer.write(((Contact) listModel.get(i)).getFormattedValue());
				writer.write(lineSeparator);
			}

			writer.flush();
			writer.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}// GEN-LAST:event_saveButtonActionPerformed

	// GEN-FIRST:event_removeButtonActionPerformed
	private void removeButtonActionPerformed(java.awt.event.ActionEvent evt) {
		Contact contact = (Contact) contactList.getSelectedValue();

		if (contact == null)
			return;

		int response = JOptionPane.showConfirmDialog(this,
				"Are you sure you want to erase '" + contact + "'?",
				"Remove Confirmation", JOptionPane.YES_NO_OPTION);

		if (response == JOptionPane.YES_OPTION) {
			listModel.removeElement(contact);
			updateContactCount();
		}
	}// GEN-LAST:event_removeButtonActionPerformed

	// GEN-FIRST:event_addButtonActionPerformed
	private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {
		Contact contact = editContactDialog.addEditContact(null);
		
		if(contact!= null) {
			listModel.addElement(contact);
			updateContactCount();
		}
		
		
	}// GEN-LAST:event_addButtonActionPerformed

	// GEN-FIRST:event_editButtonActionPerformed
	private void editButtonActionPerformed(java.awt.event.ActionEvent evt) {
		Contact contact = (Contact) contactList.getSelectedValue();

		if (contact == null)
			return;

		editContactDialog.addEditContact(contact);
		contactList.repaint();
	}// GEN-LAST:event_editButtonActionPerformed

	
	// GEN-FIRST:event_closeButtonActionPerformed
	private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {
		int response = JOptionPane.showConfirmDialog(this,
				"Are you sure you want to exit?", "Confirm Exit",
				JOptionPane.YES_NO_OPTION);

		if (response == JOptionPane.OK_OPTION)
			System.exit(0);
	}// GEN-LAST:event_c
}
