package com.myeclipseide.examples.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.border.LineBorder;

public class EditContactDialog extends JDialog {

	private static final long serialVersionUID = 1L;
	private JTextField firstNameTextField;
	private JTextField lastNameTextField;
	private JTextField emailTextField;
	private JTextField phoneTextField;
	private Contact currentContact;
	private JButton addButton;
	private JTextArea notesTextArea;

	public Contact addEditContact(Contact contact) {
		this.currentContact = contact;
		
		if (this.currentContact == null) {
			/* Add */
			addButton.setText("Add");
			
			/* Reset fields */
			firstNameTextField.setText("");
			lastNameTextField.setText("");
			emailTextField.setText("");
			phoneTextField.setText("");
			notesTextArea.setText("");
			
			this.currentContact = new Contact();
		} else {
			/* Edit */
			addButton.setText("Update");

			firstNameTextField.setText(contact.getFirstName());
			lastNameTextField.setText(contact.getLastName());
			emailTextField.setText(contact.getEmail());
			phoneTextField.setText(contact.getPhone());
			notesTextArea.setText(contact.getNotes());
		}

		setLocationRelativeTo(getParent());
		setVisible(true);
		
		return this.currentContact;
	}

	/**
	 * Create the dialog.
	 */
	public EditContactDialog() {
		setModal(true);
		setAlwaysOnTop(true);
		setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		addWindowListener(new java.awt.event.WindowAdapter() {
			@Override
			public void windowClosing(java.awt.event.WindowEvent evt) {
				formWindowClosing(evt);
			}
		});
		setTitle("Add / Edit Contact");
		setBounds(100, 100, 630, 363);
		getContentPane().setLayout(null);
		
		JLabel firstNameLabel = new JLabel("First Name:");
		firstNameLabel.setHorizontalAlignment(SwingConstants.RIGHT);
		firstNameLabel.setBounds(12, 38, 92, 14);
		getContentPane().add(firstNameLabel);
		
		firstNameTextField = new JTextField();
		firstNameTextField.setBounds(122, 33, 160, 25);
		getContentPane().add(firstNameTextField);
		firstNameTextField.setColumns(10);
		
		JLabel lastNameLabel = new JLabel("Last Name:");
		lastNameLabel.setHorizontalAlignment(SwingConstants.RIGHT);
		lastNameLabel.setBounds(283, 38, 104, 14);
		getContentPane().add(lastNameLabel);
		
		lastNameTextField = new JTextField();
		lastNameTextField.setBounds(408, 33, 160, 25);
		getContentPane().add(lastNameTextField);
		lastNameTextField.setColumns(10);
		
		JLabel emailLabel = new JLabel("Email:");
		emailLabel.setHorizontalAlignment(SwingConstants.RIGHT);
		emailLabel.setBounds(58, 75, 46, 14);
		getContentPane().add(emailLabel);
		
		emailTextField = new JTextField();
		emailTextField.setBounds(122, 70, 160, 25);
		getContentPane().add(emailTextField);
		emailTextField.setColumns(10);
		
		JLabel phoneLabel = new JLabel("Phone:");
		phoneLabel.setHorizontalAlignment(SwingConstants.RIGHT);
		phoneLabel.setBounds(336, 75, 54, 14);
		getContentPane().add(phoneLabel);
		
		phoneTextField = new JTextField();
		phoneTextField.setBounds(408, 70, 160, 25);
		getContentPane().add(phoneTextField);
		phoneTextField.setColumns(10);
		
		JLabel notesLabel = new JLabel("Notes:");
		notesLabel.setHorizontalAlignment(SwingConstants.RIGHT);
		notesLabel.setBounds(31, 130, 73, 14);
		getContentPane().add(notesLabel);
		
		notesTextArea = new JTextArea();
		notesTextArea.setBounds(122, 129, 444, 149);
		notesTextArea.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
		getContentPane().add(notesTextArea);
		{
			addButton = new JButton("Add/Update");
			addButton.setBounds(350, 290, 117, 23);
			getContentPane().add(addButton);
			addButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					addButtonActionPerformed(e);
				}
			});
			addButton.setActionCommand("OK");
			getRootPane().setDefaultButton(addButton);
		}
		{
			JButton cancelButton = new JButton("Cancel");
			cancelButton.setBounds(474, 290, 92, 23);
			getContentPane().add(cancelButton);
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					cancelButtonActionPerformed(e);
				}
			});
			cancelButton.setActionCommand("Cancel");
		}
		
	}
	
	private void formWindowClosing(java.awt.event.WindowEvent evt) {
		cancelButtonActionPerformed(null);
	}//GEN-LAST:event_formWindowClosing
	
		//GEN-FIRST:event_cancelButtonActionPerformed
		private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {
		
			this.currentContact = null;
			
			setVisible(false);
		}//GEN-LAST:event_cancelButtonActionPerformed

		//GEN-FIRST:event_addButtonActionPerformed
		private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {
			currentContact.setFirstName(firstNameTextField.getText());
			currentContact.setLastName(lastNameTextField.getText());
			currentContact.setEmail(emailTextField.getText());
			currentContact.setPhone(phoneTextField.getText());
			currentContact.setNotes(notesTextArea.getText());
			
			setVisible(false);
		}//GEN-LAST:event_addButtonActionPerformed

}
