package com.myeclipseide.programmatic;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebListener;

import com.myeclipseide.progfilter.FilterServlet;

@WebListener
public class BaseServletContextListener implements ServletContextListener {

	public BaseServletContextListener() {
	}

	public void contextDestroyed(ServletContextEvent event) {
	}

	public void contextInitialized(ServletContextEvent event) {
		ServletContext context = event.getServletContext();
		addServlets(context);

	}

	private void addServlets(ServletContext context) {

		ServletRegistration.Dynamic dynamic = context.addServlet(
				"FilterServlet", FilterServlet.class);
		dynamic.addMapping("/FilterServletExample");

	}

}
