package com.myeclipseide.batch;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Payrollrecord entity. @author MyEclipse Persistence Tools
 */
@Entity
@Table(name = "PAYROLLRECORD", schema = "PAYROLL")
public class PayrollRecord implements java.io.Serializable {

	// Fields

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Integer id;
	//private int empID;
	private String monthYear;
	private int empId;
	private Integer base;
	private float tax;
	private float bonus;
	private float net;

	// Constructors

	/** default constructor */
	public PayrollRecord() {
	}

	/** minimal constructor */
	public PayrollRecord(Integer id) {
		this.id = id;
	}

	/** full constructor */
	public PayrollRecord(Integer id, String monthYear, int empId,
			Integer base, Integer tax, Integer bonus, Integer net) {
		this.id = id;
		this.monthYear = monthYear;
		this.empId = empId;
		this.base = base;
		this.tax = tax;
		this.bonus = bonus;
		this.net = net;
	}

	// Property accessors
	@Id 
	@GeneratedValue(strategy=GenerationType.IDENTITY)
	@Column(name = "id")
	public Integer getId() {
		return this.id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	@Column(name = "monthYear", length = 50)
	public String getMonthYear() {
		return this.monthYear;
	}

	public void setMonthYear(String monthYear) {
		this.monthYear = monthYear;
	}

	@Column(name = "empID", length = 50)
	public int getEmpId() {
		return this.empId;
	}

	public void setEmpId(int empId) {
		this.empId = empId;
	}

	@Column(name = "base")
	public Integer getBase() {
		return this.base;
	}

	public void setBase(Integer base) {
		this.base = base;
	}

	@Column(name = "tax", precision = 5, scale = 0)
	public float getTax() {
		return this.tax;
	}

	public void setTax(float tax) {
		this.tax = tax;
	}

	@Column(name = "bonus", precision = 5, scale = 0)
	public float getBonus() {
		return this.bonus;
	}

	public void setBonus(float bonus) {
		this.bonus = bonus;
	}

	@Column(name = "net", precision = 5, scale = 0)
	public float getNet() {
		return this.net;
	}

	public void setNet(float net) {
		this.net = net;
	}

	@Override
	public boolean equals(Object object) {
		
		if (!(object instanceof PayrollRecord)) {
			return false;
		}
		PayrollRecord other = (PayrollRecord) object;
		return empId == other.empId && monthYear.equals(other.monthYear);
	}

	@Override
	public String toString() {
		return "PayrollRecord[ id= [" + monthYear + ":" + empId + "]";
	}

}