package com.myeclipseide.batch;

import java.io.IOException;
import java.util.Properties;
import java.util.Set;

import javax.batch.operations.JobOperator;
import javax.batch.runtime.BatchRuntime;
import javax.ejb.EJB;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceUnit;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name = "/calcpayroll")
public class PayRollCalculatorServlet extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@EJB
	private SampleDataHolderBean dataBean;

	@PersistenceUnit
	private EntityManagerFactory emf;
	private EntityManager em;

	/**
	 * The doGet method of the servlet. <br>
	 * 
	 * This method is called when a form has its tag value method equals to get.
	 * 
	 * @param request
	 *            the request send by the client to the server
	 * @param response
	 *            the response send by the server to the client
	 * @throws ServletException
	 *             if an error occurred
	 * @throws IOException
	 *             if an error occurred
	 */

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		String submitAction = request
				.getParameter(PayRollConstants.SUBMIT_ACTION);
		String selectedMonthYear = request
				.getParameter(PayRollConstants.INPUT_MONTH_YEAR);

		// if calculate payroll button is clicked calculate pay roll data
		if (PayRollConstants.CALCULATE_PAYROLL.equals(submitAction)) {
			Properties props = new Properties();
			props.setProperty(PayRollConstants.MONTH_YEAR, selectedMonthYear);
			JobOperator jobOperator = BatchRuntime.getJobOperator();
			jobOperator.start(PayRollConstants.PAYROLL_JOB, props);
			try {
				Thread.sleep(3000);
			} catch (Exception ex) {
			}
			request.setAttribute(PayRollConstants.SUCCESS, "true");
			getServletContext().getRequestDispatcher(
					"/" + PayRollConstants.PAYROLL_JSP).forward(request,
					response);
			return;
		}

		// if upload button is clicked upload data into database
		if (PayRollConstants.UPLOAD.equals(submitAction)) {
			try {
				em = emf.createEntityManager();
				InitialContext ctx = new InitialContext();
				dataBean = (SampleDataHolderBean) ctx
						.lookup(PayRollConstants.BEAN_LOOKUP_NAME);

				Set<PayrollRecord> payrolls = dataBean
						.getPayrollRecords(selectedMonthYear);
				for (PayrollRecord payrollRecord : payrolls) {
					EntityTransaction transaction = em.getTransaction();
					transaction.begin();
					em.persist(payrollRecord);
					transaction.commit();

				}
				response.sendRedirect(PayRollConstants.PAYROLL_JSP + "?"
						+ PayRollConstants.STATUS + "="
						+ PayRollConstants.SUCCESS);
			} catch (NamingException ex) {
				throw new PayRollAppException(ex);
			} finally {
				dataBean.clear();
				em.flush();

			}
		}

	}

}
