package com.myeclipseide.logon.jsf;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;

import com.myeclipseide.logon.jpa.EntityManagerHelper;
import com.myeclipseide.logon.jpa.Users;
import com.myeclipseide.logon.jpa.UsersDAO;

@ManagedBean(name = "registerBean")
public class RegisterBean {
	
	private String firstName;
	private String lastName;
	private String fullName;
	private String userName;
	private String password;
	private String status;
	public String getStatus() {
		return status;
	}
	public void setStatus(String status) {
		this.status = "false";
	}
	public String getFirstName() {
		return firstName;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	public String getLastName() {
		return lastName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	public String getFullName() {
		return fullName;
	}
	public void setFullName(String fullName) {
		this.fullName = fullName;
	}
	public String getUserName() {
		return userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}
	public String getPassword() {
		return password;
	}
	public void setPassword(String password) {
		this.password = password;
	}
	
	public void register(){
		
		EntityManagerHelper.beginTransaction();
		Users user = new Users();
		user.setLogin(userName);
		user.setPassword(password);
		user.setName(firstName +" "+ lastName);
		
		UsersDAO userDAO = new UsersDAO();
		userDAO.save(user);
		EntityManagerHelper.commit();
		FacesMessage msg = new FacesMessage("New User Created!");
		msg.setSeverity(FacesMessage.SEVERITY_INFO);
		FacesContext.getCurrentInstance().addMessage("registerForm", msg);
		this.status="true";
		
	}
	
	

}
