/*
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * "The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is ICEfaces 1.5 open source software code, released
 * November 5, 2006. The Initial Developer of the Original Code is ICEsoft
 * Technologies Canada, Corp. Portions created by ICEsoft are Copyright (C)
 * 2004-2006 ICEsoft Technologies Canada, Corp. All Rights Reserved.
 *
 * Contributor(s): _____________________.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"
 * License), in which case the provisions of the LGPL License are
 * applicable instead of those above. If you wish to allow use of your
 * version of this file only under the terms of the LGPL License and not to
 * allow others to use your version of this file under the MPL, indicate
 * your decision by deleting the provisions above and replace them with
 * the notice and other provisions required by the LGPL License. If you do
 * not delete the provisions above, a recipient may use your version of
 * this file under either the MPL or the LGPL License."
 *
 */
package org.icefaces.ui;

import java.util.ArrayList;

import javax.faces.event.ActionEvent;

import org.icefaces.jpa.Customer;
import org.icefaces.jpa.CustomerDAO;
import org.icefaces.jpa.EntityManagerHelper;

import com.icesoft.faces.component.ext.RowSelectorEvent;

public final class SessionBean extends Object {

	private static boolean initialized = false;
	private static final Object lock = new Object();
	
	private CustomerDAO customerDAO = new CustomerDAO();
	private ArrayList<CustomerBean> customerList = new ArrayList<CustomerBean>();
	private CustomerBean selectedCustomerBean;
	private boolean selectedView = false;

	public SessionBean() {
		synchronized (lock) {
			if (!initialized) {
				CustomerList.customerList = new ArrayList<Customer>(customerDAO
						.findAll());
				initialized = true;
			}
		}
		
		for (int i = 0; i < CustomerList.customerList.size(); i++) {
			customerList
					.add(new CustomerBean(CustomerList.customerList.get(i)));
		}
	}

	/**
	 * @return the customerDAO
	 */
	public CustomerDAO getCustomerDAO() {
		return customerDAO;
	}

	/**
	 * @param customerDAO
	 *            the customerDAO to set
	 */
	public void setCustomerDAO(CustomerDAO customerDAO) {
		this.customerDAO = customerDAO;
	}

	public ArrayList<CustomerBean> getCustomerList() {
		return customerList;
	}

	public void setCustomerList(ArrayList<CustomerBean> customerList) {
		this.customerList = customerList;
	}

	public void rowSelected(RowSelectorEvent e) {
		selectedCustomerBean = customerList.get(e.getRow());
		selectedCustomerBean.setTempcontactfirstname(selectedCustomerBean
				.getCustomer().getContactfirstname());
		selectedCustomerBean.setTempcontactlastname(selectedCustomerBean
				.getCustomer().getContactlastname());
		selectedView = true;
	}

	public CustomerBean getSelectedCustomerBean() {
		return selectedCustomerBean;
	}

	public void setSelectedCustomerBean(CustomerBean selectedCustomerBean) {
		this.selectedCustomerBean = selectedCustomerBean;
	}

	public boolean isSelectedView() {
		return selectedView;
	}

	public void setSelectedView(boolean selectedView) {
		this.selectedView = selectedView;
	}

	public void commit(ActionEvent e) {
		selectedCustomerBean.getCustomer().setContactfirstname(
				selectedCustomerBean.getTempcontactfirstname());
		selectedCustomerBean.getCustomer().setContactlastname(
				selectedCustomerBean.getTempcontactlastname());
		EntityManagerHelper.beginTransaction();
		customerDAO.update(selectedCustomerBean.getCustomer());
		EntityManagerHelper.commit();
		selectedView = !selectedView;
	}

	public void cancel(ActionEvent e) {
		selectedView = !selectedView;
	}
}
